﻿//////////////////////////////////////////////
// RenderContextManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class RenderContextDescriptor ;
	class System ;
}

namespace nkWinUi
{
	class Window ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "RenderContext.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <unordered_map>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderContextManager final : public nkCommon::MaybeSingletonClass<RenderContextManager>
	{		
		public :

			// Getters
			const std::unordered_map<void*, nkMemory::UniquePtr<RenderContext>>& getRenderContextMap () const ;
			RenderContext* getRenderContextOf (nkWinUi::Window* win) const ;
			RenderContext* getActiveRenderContext () const ;
			RenderContext* getDefaultRenderContext () const ;

			// Lifetimes
			RenderContext* createRenderContext (const RenderContextDescriptor& contextDesc) ;
			void eraseFor (nkWinUi::Window* win) ;
			void erase (RenderContext* context) ;

			// Activation
			void activateContextOf (nkWinUi::Window* win) ;
			void activateContext (RenderContext* context) ;

		private :

			// Functions
			// Constructors
			RenderContextManager (bool isSingleton) noexcept ;
			RenderContextManager (System* system) noexcept ;
			RenderContextManager (const RenderContextManager&) = delete ;

			// Lifetime
			void _initializeDummyContext () ;

			// Operators
			RenderContextManager& operator= (const RenderContextManager&) = delete ;

		private :
		
			// Attributes
			std::unordered_map<void*, nkMemory::UniquePtr<RenderContext>> _contextMap ;

			nkMemory::UniquePtr<RenderContext> _dummyContext ;
			RenderContext* _activatedContext ;

			System* _system ;

			unsigned int _idCounter ;

		private :

			friend class nkCommon::MaybeSingletonClass<RenderContextManager> ;
			friend class System ;
	} ;
}